/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.spigot;

import net.skinsrestorer.shared.storage.Config;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpigotPassengerUtil {
    public static void refreshPassengers(JavaPlugin plugin, Player player, Entity vehicle, boolean disableDismountPlayer, boolean disableRemountPlayer, boolean enableDismountEntities) {
        if (Config.DISMOUNT_PLAYER_ON_UPDATE && !disableDismountPlayer && vehicle != null) {
            vehicle.removePassenger((Entity)player);
            if (Config.REMOUNT_PLAYER_ON_UPDATE && !disableRemountPlayer) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, () -> {
                    if (vehicle.isValid()) {
                        vehicle.addPassenger((Entity)player);
                    }
                }, 1L);
            }
        }
        if ((Config.DISMOUNT_PASSENGERS_ON_UPDATE || enableDismountEntities) && !player.isEmpty()) {
            for (Entity passenger : player.getPassengers()) {
                player.removePassenger(passenger);
            }
        }
    }
}

